//Lid Walls.scad;

//All walls are the same height, 
//suitable for an Arduino UNO,
//with an Adafruit TFT on top;

//Warning!
//This module defines the four vertical 
//walls of a case that is suitable for 
//the Adafruit V2 TFT, not for the V1 TFT;  
//That is a little longer and would 
//need a bigger case;

//Refinements to include in later 
//assemblies include:
//  Rounded corners;
//  The lid top;
//  The holes for the 
//  USB and DC power connectors;

//The walls are constructed resting 
//on the XY plane;
//However, the subtlety of the center=true 
//below is important and can't be ignored; 

include <UNO_Dimensions.scad>

module LidWalls()
{

echo("Begin LidWalls");
    
WallDeltaX = WallInnerX/2 +WallThickness/2;
WallDeltaY = WallInnerY/2 +WallThickness/2;
WallDeltaZ = WallZ/2;
    
//Left wall
LeftWallX = WallThickness;
LeftWallY = WallInnerY +WallThickness;
    
translate([-WallDeltaX, 0, WallDeltaZ])
cube([LeftWallX, LeftWallY, WallZ], center=true);

//Right wall
RightWallX = LeftWallX;
RightWallY = LeftWallY;
    
translate([WallDeltaX, 0, WallDeltaZ])
cube([RightWallX, RightWallY, WallZ], center=true);

//Front wall
FrontWallX = WallInnerX +WallThickness;
FrontWallY = WallThickness;
    
translate([0, -WallDeltaY, WallDeltaZ])
cube([FrontWallX, FrontWallY, WallZ], center=true);

//Rear wall
RearWallX = FrontWallX;
RearWallY = FrontWallY;
    
translate([0, WallDeltaY, WallDeltaZ])
cube([RearWallX, RearWallY, WallZ], center=true);

//I want four corners;

translate([-WallDeltaX, -WallDeltaY, 0])
cylinder(h=WallZ, d=WallThickness, $fn=36);

translate([-WallDeltaX, WallDeltaY, 0])
cylinder(h=WallZ, d=WallThickness, $fn=36);

translate([WallDeltaX, -WallDeltaY, 0])
cylinder(h=WallZ, d=WallThickness, $fn=36);

translate([WallDeltaX, WallDeltaY, 0])
cylinder(h=WallZ, d=WallThickness, $fn=36);

}
//
